当前的脚本接口文档的预发行版是从基础.NET和C＃源自动生成的。因此，文档中包含一些Python程序员不熟悉的表达式。以下概述提供了有关如何从Python角度理解这些表达式的一些技巧。

- 接口是一种契约，它告诉实现该接口的类的实例，该类必须准备哪些成员（方法，属性）。在IronPython中，你可以通过从超类继承来在一个类中实现一个或多个.NET接口。如果接口需要一个方法，但在类定义中不可用，则返回异常（DeviceImportFromSvn.py示例显示了实现ImportReporter接口的类。
- .NET中的每个参数和每个方法均严格输入。参数的类型用参数名称前的一个空格字符分隔，方法的返回值类型用方法名称前的一个空格字符分隔。定义类（或接口）时，可以使用子类的实例。没有返回值的方法被标记为void。
- 你可以重载方法，因为同一类中可以存在多个名称方法。但是，参数的数量或类型必须不同。IronPython自动处理最合适的方法重载。
- 数据类型int对应于-2,147,483,648到2,147,483,647之间的整数。  
    数据类型bool对应于Python类型bool（True和False）。  
    数据类型string对应于Python类型str或unicode，在IronPython中相同。  
    IDictionary数据类型对应于普通的Python字典。IronPython自动在Python和.NET数据类型之间转换。
- 如果从IBaseObject继承了T类型，则意味着可以由其他插件扩展该类型以获得其他成员。将此扩展类型作为参数或返回值的实际用法由IExtendedObject标记。
- T类型的IEnumerable接口意味着你可以使用返回T类型值（或子类）的每个Python序列（生成器，列表，元组等）。返回不兼容对象的序列，并在运行时引发异常。
- T类型的IList接口标识一个典型列表，该列表保证仅包括T类型的元素（或子类）。尝试添加不兼容的对象时，将在运行时引发异常。
- 类型T的参数的params T\[\] nameid对应于Python机制变量参数列表的\*name。
- 在Python中，枚举（enum）作为语言构造不存在。其目的是为特定目的（例如一周中的几天）定义确切数量的常数。通过使用“ Name.Member”，例如通过OnlineChangeOption.Try，可以从IronPython访问.NET枚举。  
    （有很多方法可以在Python中模拟枚举。例如, 查看http://pypi.python.org/pypi/enum/或http://www.ironpython.info/index.php/Enumerations.)
- 语法T name { get; set; }定义一个属性，名称为name，类型为T。如果set;丢失，则该属性为只读。在Python中，相应的构造是@property装饰器。